﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VRMRest;
using System.Net.Http;
using System.Threading;

namespace RestCallTests
{
    [TestClass]
    public class UnitTest1
    {
        LogSettings _logSettings = new LogSettings() { Org = "CRMEDEV", ConfigFieldName = "RESTTEST", UserId = Guid.Parse("38045B35-D411-E411-AE3F-00155D14D952") };

        Uri _baseUri = new Uri("https://CRMDAC.CRMUD.dev.CRM.VRM.vba.VA.GOV:8085");

        #region OneWay Sync Test
        [TestMethod]
        public void OneWayTest()
        {

            OneWayPassTest oneWayPassTest = new OneWayPassTest() {MessageId = "testMessage", LastName = "testLast", FirstName = "testfirst", Ssn = "123456789" };

            HttpResponseMessage response = Utility.Send(_baseUri, Utility.OneWayPassTest, oneWayPassTest, _logSettings);

            Assert.IsTrue(response.StatusCode == System.Net.HttpStatusCode.OK);

        }

        [TestMethod]
        [ExpectedException(typeof(AggregateException))]
        public void TestBadEndPoint()
        {

            Uri uri = new Uri("http://BadEndpoint:8085");
            OneWayPassTest oneWayPassTest = new OneWayPassTest() { MessageId = "testMessage", LastName = "testLast", FirstName = "testfirst", Ssn = "123456789" };

            HttpResponseMessage response = Utility.Send(uri, Utility.OneWayPassTest, oneWayPassTest, _logSettings);

       

        }
        #endregion

        #region OneWay Async Test
        [TestMethod]
        public void AsyncTest()
        {


            OneWayPassTest oneWayPassTest = new OneWayPassTest() { MessageId = "testMessage", LastName = "testLast", FirstName = "testfirst", Ssn = "123456789" };

            Utility.SendAsync(_baseUri, Utility.OneWayPassTest, oneWayPassTest, _logSettings, Callback);

            Thread.Sleep(30000);

        }

        private static void Callback(HttpResponseMessage responseMessage)
        {
            Console.WriteLine(responseMessage.StatusCode);
        }
        #endregion

        #region TwoWay Test
        [TestMethod]
        public void TwoWayTest()
        {

            TwoWayPassTest twoWayPassTest = new TwoWayPassTest() { MessageId = "testMessage", LastName = "testLast", FirstName = "testfirst", Ssn = "123456789" };

            TwoWayPassResponseTest twoWayPassResponseTest = Utility.SendReceive<TwoWayPassResponseTest>(_baseUri, Utility.TwoWayPassTest, twoWayPassTest, _logSettings);

            Assert.IsTrue(twoWayPassResponseTest.FullName.Equals("testLast, testfirst"));
        }

        [TestMethod]
        [ExpectedException(typeof(HttpRequestException))]
        public void TwoWayTestUnknownMessageType()
        {

            TwoWayPassTest twoWayPassTest = new TwoWayPassTest() { MessageId = "testMessage", LastName = "testLast", FirstName = "testfirst", Ssn = "123456789" };

            TwoWayPassResponseTest twoWayPassResponseTest = Utility.SendReceive<TwoWayPassResponseTest>(_baseUri, "BadMessageType", twoWayPassTest, _logSettings);

            Assert.IsTrue(twoWayPassResponseTest.FullName.Equals("testLast, testfirst"));
        }

        [TestMethod]
        [ExpectedException(typeof(HttpRequestException))]
        public void TwoWayTestNoMessageId()
        {
            //If no MessageId is not in the object, will get a Bad Request error
            BadObjectTest badObject = new BadObjectTest() { FirstNoMessageId = "1", UnknownField = "Unknown" };

            TwoWayPassResponseTest twoWayPassResponseTest = Utility.SendReceive<TwoWayPassResponseTest>(_baseUri, Utility.TwoWayPassTest, badObject, _logSettings);

        }


        #endregion

        public class BadObjectTest
        {
            public string FirstNoMessageId { get; set; }
            public string UnknownField { get; set; }
        }
        [TestMethod]
        public void FormatUri()
        {
            var actual = Utility.FormatUri(_baseUri, "Send", "TestMessages#OneWayPassTest");
        }

        [TestMethod]
        public void LogErrorTest()
        {

            try
            {
                throw new Exception("Test Error from Unit Test");
            }
            catch (Exception ex)
            {
                Utility.LogError(_baseUri, _logSettings, "LogErrorTest", ex);
            }
            Assert.Inconclusive("Check CRM Log Entity");
        }


    }
}
